rm(list=ls(all=TRUE))

load("SOFA-data.RData")

# # 15-point Gauss-Legendre quadrature
xk <- c(-0.98799251802048542849,-0.937273392400705904308,-0.8482065834104272162006,
        -0.7244177313601700474162,-0.5709721726085388475372,-0.3941513470775633698972,
        -0.2011940939974345223006,0,0.2011940939974345223006,0.3941513470775633698972,
        0.5709721726085388475372,0.7244177313601700474162,0.8482065834104272162006,
        0.9372733924007059043078,0.9879925180204854284896)

wk <- c(0.0307532419961172683546,0.070366047488108124709,0.1071592204671719350119,
        0.1395706779261543144478,0.1662692058169939335532,0.1861610000155622110268,
        0.1984314853271115764561,0.2025782419255612728806,0.198431485327111576456,
        0.1861610000155622110268,0.166269205816993933553,0.139570677926154314448,
        0.10715922046717193501,0.07036604748810812471,0.030753241996117268355)


ysofa <- matrix(NA,nrow(data.patients),max(data.total$day))
M1 <- as.numeric(table(data.total$id))
for(i in 1:nrow(data.patients)){ysofa[i,1:M1[i]] <- log(data.total$sofa1[data.total$id==unique(data.total$id)[i]])}

# remove
ysofa[131,c(2,3)] <- c(NA,NA)
ysofa[12,c(5,6)] <- c(NA,NA)
M1[131] <- 1
M1[12] <- 4
data.patients$status[131] <- 0
data.patients$status[12] <- 0
data.patients$time[131] <- 1
data.patients$time[12] <- 4


# new observations
long12.1 <- c(2.302585,2.302585,2.302585)
long12.2 <- c(2.302585,2.302585,2.302585,1.609438)
long131 <- 2.833213

bss <- do.call(rbind,jags.parsamples)
sims.list <- vector("list", length(params.JAGS))
names(sims.list) <- params.JAGS

# place the sample of the parameters of interest in the list
for(p in seq_along(params.JAGS)){
  iik <- grep(paste("^", params.JAGS[p], sep=""), colnames(bss))
  sims.list[[p]] <- bss[,iik]
}


#  reweighting

### Longitudinal
beta0 <- sims.list[[1]][,1]
beta1 <- sims.list[[1]][,2]
beta2 <- sims.list[[1]][,3]
lsigma <- log(sims.list[[2]][,1])
lsigma0 <- log(sims.list[[2]][,2])
lsigma1 <- log(sims.list[[2]][,3])

### Competing risks
gamma1 <- sims.list[[10]]
gamma2 <- sims.list[[9]]
alpha01 <- sims.list[[12]]
alpha02 <- sims.list[[11]]
alpha11 <- sims.list[[14]]
alpha12 <- sims.list[[13]]
lnu1 <- log(sims.list[[6]])
lnu2 <- log(sims.list[[5]])
llambda1 <- sims.list[[8]]
llambda2 <- sims.list[[7]]


require(randtoolbox)

Q <- 250
a <- sobol(Q, dim=4, scrambling=1, seed=sample(100000,1))
#a <- matrix(runif(2*Q,0,1),Q)
den.like.long <- rep(0,length(beta0))
den.like.surv <- rep(0,length(beta0))
num.like.long <- rep(0,length(beta0))
num.like.surv <- rep(0,length(beta0))
day1.12 <- 1:length(long12.1)
day2.12 <- 1:length(long12.2)
day1.131 <- 1:length(long131)
Time1.12 <- length(day1.12)
Time2.12 <- length(day2.12)
Time1.131 <- length(day1.131)
age12 <- 71
age131 <- 63
delta12 <- 0
delta131 <- 0
K <- 15
hA1.12 <- rep(0,K)
hA2.12 <- rep(0,K)
hA131 <- rep(0,K)
hD1.12 <- rep(0,K)
hD2.12 <- rep(0,K)
hD131 <- rep(0,K)

init <- Sys.time()
for(k in 1:length(beta0)){
  l1 <- 0
  l2 <- 0
  l3 <- 0
  s1 <- 0
  s2 <- 0
  s3 <- 0
  for(q in 1:Q){
    b0.12 <- exp(lsigma0[k])*qnorm(a[q,1])
    b1.12 <- exp(lsigma1[k])*qnorm(a[q,2])
    b0.131 <- exp(lsigma0[k])*qnorm(a[q,3])
    b1.131 <- exp(lsigma1[k])*qnorm(a[q,4])    
    
    psi1 <- long12.1 - (beta0[k]+b0.12 + (beta1[k]+b1.12)*day1.12 + beta2[k]*age12)
    psi2 <- long12.2 - (beta0[k]+b0.12 + (beta1[k]+b1.12)*day2.12 + beta2[k]*age12)
    psi3 <- long131 - (beta0[k]+b0.131 + (beta1[k]+b1.131)*day1.131 + beta2[k]*age131)
    
    for(j in 1:K){
        hA1.12[j] <- exp(lnu1[k])*(Time1.12/2*(xk[j]+1))^(exp(lnu1[k])-1) *
          exp( llambda1[k] + gamma1[k]*age12 + alpha01[k]*b0.12 + alpha11[k]*b1.12*(Time1.12/2*(xk[j]+1)) )
        hA2.12[j] <- exp(lnu1[k])*(Time2.12/2*(xk[j]+1))^(exp(lnu1[k])-1) *
          exp( llambda1[k] + gamma1[k]*age12 + alpha01[k]*b0.12 + alpha11[k]*b1.12*(Time2.12/2*(xk[j]+1)) )
        hA131[j] <- exp(lnu1[k])*(Time1.131/2*(xk[j]+1))^(exp(lnu1[k])-1) *
          exp( llambda1[k] + gamma1[k]*age131 + alpha01[k]*b0.131 + alpha11[k]*b1.131*(Time1.131/2*(xk[j]+1)) )      
      
        hD1.12[j] <- exp(lnu2[k])*(Time1.12/2*(xk[j]+1))^(exp(lnu2[k])-1) *
          exp( llambda2[k] + gamma2[k]*age12 + alpha02[k]*b0.12 + alpha12[k]*b1.12*(Time1.12/2*(xk[j]+1)) )
        hD2.12[j] <- exp(lnu2[k])*(Time2.12/2*(xk[j]+1))^(exp(lnu2[k])-1) *
          exp( llambda2[k] + gamma2[k]*age12 + alpha02[k]*b0.12 + alpha12[k]*b1.12*(Time2.12/2*(xk[j]+1)) )
        hD131[j] <- exp(lnu2[k])*(Time1.131/2*(xk[j]+1))^(exp(lnu2[k])-1) *
          exp( llambda2[k] + gamma2[k]*age131 + alpha02[k]*b0.131 + alpha12[k]*b1.131*(Time1.131/2*(xk[j]+1)) )
    }
    
    l1 <- l1 + (1/(2*pi*exp(lsigma[k])^2))^(Time1.12/2)*exp(-(1/(2*exp(lsigma[k])^2))*sum(psi1^2))
    s1 <- s1 + exp(-Time1.12/2*( sum(wk*hA1.12) + sum(wk*hD1.12) ))
    l2 <- l2 + (1/(2*pi*exp(lsigma[k])^2))^(Time2.12/2)*exp(-(1/(2*exp(lsigma[k])^2))*sum(psi2^2))
    s2 <- s2 + exp(-Time2.12/2*( sum(wk*hA2.12) + sum(wk*hD2.12) ))
    l3 <- l3 + (1/(2*pi*exp(lsigma[k])^2))^(Time1.131/2)*exp(-(1/(2*exp(lsigma[k])^2))*sum(psi3^2))
    s3 <- s3 + exp(-Time1.131/2*( sum(wk*hA131) + sum(wk*hD131) ))
  }
  den.like.long[k] <- l1/Q
  den.like.surv[k] <- s1/Q
  num.like.long[k] <- l2*l3/Q
  num.like.surv[k] <- s2*s3/Q
}
end <- Sys.time()
end-init

w <- (num.like.long*num.like.surv) / (den.like.long*den.like.surv)

# degeneracy criterion
ESS <- (sum(w)^2)/(sum(w^2))
(ESS/length(beta0) < 0.5) # FALSE: not update

# resampling
weights <- w/sum(w)
